// uploadData.js
const mongoose = require("mongoose");
const XLSX = require("xlsx");
const path = require("path");
require("dotenv").config();

const locations = require("./src/models/locations");

// ----------------------
// 1️⃣ Connect to MongoDB
// ----------------------
mongoose
  .connect(
    "mongodb+srv://website_db_user:6FUMrfa3CJtY1fHF@cluster0.3vvebnn.mongodb.net/?appName=Cluster0"
  )
  .then(() => console.log("✅ Connected to MongoDB"))
  .catch((err) => console.error("❌ MongoDB connection error:", err));

// ----------------------
// 2️⃣ Load Excel File
// ----------------------
const filePath = path.join(
  "C:",
  "Users",
  "Ahmad Jamil",
  "Downloads",
  "locations.xls" // ensure correct extension
);

const workbook = XLSX.readFile(filePath);
console.log("📄 Sheets found:", workbook.SheetNames);

const sheetName = workbook.SheetNames[0];
const worksheet = workbook.Sheets[sheetName];
// Convert sheet to JSON
let data = XLSX.utils.sheet_to_json(worksheet, { defval: "" });

// ----------------------
// 3️⃣ Clean and Transform Data
// ----------------------
if (data.length === 0) {
  console.error(
    "⚠️ No data found in Excel file! Check your headers or sheet name."
  );
  mongoose.connection.close();
  process.exit(1);
}

// console.log(`📊 Loaded ${data.length} rows from Excel.`);
// console.log("🔍 Preview first 3 rows:", data.slice(0, 3));

data = data.map((item) => {
  return {
    name: item.name,
    SECNO: item.SECNO,
    deliveryCost: item.deliveryCost,
  };
});

console.log(`✅ Prepared ${data.length} valid locations for insertion.`);

// console.log("data:", data);

// ----------------------
// 4️⃣ Upload to MongoDB
// ----------------------
(async () => {
  try {
    await locations.deleteMany({}); // optional — clears existing data first
    console.log("🗑️ Old locations cleared.");

    const inserted = await locations.insertMany(data);
    console.log(`🎉 Successfully inserted ${inserted.length} locations!`);
  } catch (err) {
    console.error("❌ Error inserting data:", err);
  } finally {
    mongoose.connection.close();
    console.log("🔌 MongoDB connection closed.");
  }
})();
